#include <solomon/services/fetcher/lib/data_sink/counters.h>

#include <library/cpp/monlib/consumers/collecting_consumer.h>
#include <library/cpp/monlib/metrics/fake.h>
#include <library/cpp/testing/gtest/gtest.h>

using namespace testing;
using namespace NSolomon;
using namespace NSolomon::NFetcher;
using namespace NMonitoring;

MATCHER_P(HasLabel, label, "") {
    auto maybeLabel = arg.Labels.Get(label.Name());
    if (!maybeLabel) {
        return false;
    }

    return (*maybeLabel)->Value() == label.Value();
}

class TCoremonShardMetricsTest: public ::testing::Test {
public:
    void SetUp() override {
        Registry_ = std::make_shared<TMetricRegistry>();
    }

    void TearDown() override {
        Registry_ = nullptr;
    }

protected:
    std::shared_ptr<TMetricRegistry> Registry_;
};

TEST_F(TCoremonShardMetricsTest, AllCounters) {
    TCoremonMetricFactory factory{Registry_, EMetricVerbosity::All};
    auto counters = factory.MetricsFor("foo", "bar");

    TCollectingConsumer consumer;
    consumer.OnStreamBegin();
    Registry_->Append(TInstant::Zero(), &consumer);
    consumer.OnStreamEnd();

    ASSERT_THAT(consumer.Metrics, Contains(HasLabel(TLabel{"projectId", "foo"})));
    ASSERT_THAT(consumer.Metrics, Contains(HasLabel(TLabel{"projectId", "total"})));
    ASSERT_THAT(consumer.Metrics, Contains(HasLabel(TLabel{"shardId", "bar"})));
    ASSERT_THAT(consumer.Metrics, Contains(HasLabel(TLabel{"shardId", "total"})));
}

TEST_F(TCoremonShardMetricsTest, OnlyTotals) {
    TCoremonMetricFactory factory{Registry_, EMetricVerbosity::OnlyTotal};
    auto counters = factory.MetricsFor("foo", "bar");

    TCollectingConsumer consumer;
    consumer.OnStreamBegin();
    Registry_->Append(TInstant::Zero(), &consumer);
    consumer.OnStreamEnd();

    ASSERT_THAT(consumer.Metrics, Not(Contains(HasLabel(TLabel{"projectId", "foo"}))));
    ASSERT_THAT(consumer.Metrics, Contains(HasLabel(TLabel{"projectId", "total"})));
    ASSERT_THAT(consumer.Metrics, Not(Contains(HasLabel(TLabel{"shardId", "bar"}))));
    ASSERT_THAT(consumer.Metrics, Contains(HasLabel(TLabel{"shardId", "total"})));

    auto ewma = counters->CreateProcessingRateEwma();
    auto queueCounters = counters->CreateQueueCounters();
    ASSERT_THAT(queueCounters, NotNull());
    queueCounters->AddSize(1);
    queueCounters->IncSize();
    queueCounters->DecSize();

    auto* queueMem = counters->QueueMemEstimateCounter();
    ASSERT_THAT(queueMem, NotNull());
    queueMem->Set(123);
    ASSERT_EQ(queueMem->Get(), 0);

    // call other methods to be sure that all of them properly work in this mode
    counters->RecordResponseTime(42);
    counters->AddMetricsWritten(100500);
    counters->Success();
    counters->Fail();
    counters->IncInflight();
    counters->DecInflight();
    counters->UrlQueueOverflow();
    counters->AddMaxInflight(1);
}
