#include "dc_label.h"

namespace NSolomon::NFetcher {

TStringBuf ToDcLabel(EDc dc) noexcept {
    switch (dc) {
        case EDc::ASH:
            return TStringBuf{"Ash"};
        case EDc::MYT:
            return TStringBuf{"Myt"};
        case EDc::SAS:
            return TStringBuf{"Sas"};
        case EDc::MAN:
            return TStringBuf{"Man"};
        case EDc::IVA:
            return TStringBuf{"Iva"};
        case EDc::VEG:
            return TStringBuf{"Veg"};
        case EDc::VLA:
            return TStringBuf{"Vla"};
        case EDc::UGR:
            return TStringBuf{"Ugr"};
        case EDc::AMS:
            return TStringBuf{"Ams"};
        case EDc::FOL:
            return TStringBuf{"Fol"};
        case EDc::UNKNOWN:
            return TStringBuf("dc-unknown");
    }
}

EDc FromDcLabel(TStringBuf label) noexcept {
    if (label == "Ash") {
        return EDc::ASH;
    }
    if (label == "Myt") {
        return EDc::MYT;
    }
    if (label == "Sas") {
        return EDc::SAS;
    }
    if (label == "Man") {
        return EDc::MAN;
    }
    if (label == "Iva") {
        return EDc::IVA;
    }
    if (label == "Veg") {
        return EDc::VEG;
    }
    if (label == "Vla") {
        return EDc::VLA;
    }
    if (label == "Ugr") {
        return EDc::UGR;
    }
    if (label == "Ams") {
        return EDc::AMS;
    }
    if (label == "Fol") {
        return EDc::FOL;
    }
    return EDc::UNKNOWN;
}

} // namespace NSolomon::NFetcher
