#include <solomon/services/fetcher/lib/dc_label/dc_label.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace NFetcher;

TEST(TDcLabelTest, FromDcLabel) {
    ASSERT_EQ(FromDcLabel("dc-unknown"), EDc::UNKNOWN);
    ASSERT_EQ(FromDcLabel("Ugr"), EDc::UGR);
    ASSERT_EQ(FromDcLabel("Fol"), EDc::FOL);
    ASSERT_EQ(FromDcLabel("Iva"), EDc::IVA);
    ASSERT_EQ(FromDcLabel("Myt"), EDc::MYT);
    ASSERT_EQ(FromDcLabel("Ash"), EDc::ASH);
    ASSERT_EQ(FromDcLabel("Ams"), EDc::AMS);
    ASSERT_EQ(FromDcLabel("Veg"), EDc::VEG);
    ASSERT_EQ(FromDcLabel("Man"), EDc::MAN);
    ASSERT_EQ(FromDcLabel("Vla"), EDc::VLA);
    ASSERT_EQ(FromDcLabel("Sas"), EDc::SAS);
}

TEST(TDcLabelTest, ToDcLabel) {
    ASSERT_EQ(ToDcLabel(EDc::UNKNOWN), "dc-unknown");
    ASSERT_EQ(ToDcLabel(EDc::UGR), "Ugr");
    ASSERT_EQ(ToDcLabel(EDc::FOL), "Fol");
    ASSERT_EQ(ToDcLabel(EDc::IVA), "Iva");
    ASSERT_EQ(ToDcLabel(EDc::MYT), "Myt");
    ASSERT_EQ(ToDcLabel(EDc::ASH), "Ash");
    ASSERT_EQ(ToDcLabel(EDc::AMS), "Ams");
    ASSERT_EQ(ToDcLabel(EDc::VEG), "Veg");
    ASSERT_EQ(ToDcLabel(EDc::MAN), "Man");
    ASSERT_EQ(ToDcLabel(EDc::VLA), "Vla");
    ASSERT_EQ(ToDcLabel(EDc::SAS), "Sas");
}
