#pragma once

#include <solomon/services/fetcher/lib/events.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/dns/dns.h>
#include <solomon/libs/cpp/solomon_env/dc.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/ipv6_address/ipv6_address.h>
#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon::NFetcher {
    struct THostResolverEvents: private TEventSlot<EEventSpace::Fetcher, FS_HOST_RESOLVER> {
        enum {
            EvStartResolving = SpaceBegin,
            EvStopResolving,
            EvHostResolveOk,
            EvHostResolveFail,
            End,
        };
        static_assert(End < SpaceEnd, "too many event types");
    };

    struct TEvStartResolving: NActors::TEventLocal<TEvStartResolving, THostResolverEvents::EvStartResolving> {
        explicit TEvStartResolving(TString hostname) noexcept
            : Hostname{std::move(hostname)}
        {
        }

        TString Hostname;
    };

    struct TEvStopResolving: NActors::TEventLocal<TEvStopResolving, THostResolverEvents::EvStopResolving> {
        explicit TEvStopResolving(TString hostname) noexcept
            : Hostname{std::move(hostname)}
        {
        }

        TString Hostname;
    };

    enum class EErrorType {
        Unknown = 0,
        Timeout,
        NotFound,
    };

    struct TEvHostResolveOk: NActors::TEventLocal<TEvHostResolveOk, THostResolverEvents::EvHostResolveOk> {
        TEvHostResolveOk(TString hostname, TIpv6Address address, EDc dc)
            : Hostname{std::move(hostname)}
            , Address{std::move(address)}
            , Dc{dc}
        {
        }

        TString Hostname;
        TIpv6Address Address;
        EDc Dc;
    };

    struct TEvHostResolveFail: NActors::TEventLocal<TEvHostResolveFail, THostResolverEvents::EvHostResolveFail> {
        TEvHostResolveFail(EErrorType type, TString hostname, TString reason) noexcept
            : Type{type}
            , Hostname{std::move(hostname)}
            , Reason{std::move(reason)}
        {
        }

        EErrorType Type;
        TString Hostname;
        TString Reason;
    };

    struct TDnsResolverActorConf {
        TDuration RefreshInterval {TDuration::Minutes(5)};
        TDuration WakeupInterval {TDuration::Seconds(30)};

        IDnsClientPtr DnsClient;
        NMonitoring::TMetricRegistry& MetricRegistry;
        NActors::TActorId RackTablesActorId;
    };

    NActors::TActorId MakeDnsResolverId();
    NActors::IActor* CreateDnsResolverActor(TDnsResolverActorConf conf);
} // namespace NSolomon::NFetcher
