#pragma once

#include <solomon/services/fetcher/lib/events.h>
#include <solomon/services/fetcher/lib/host_groups/host_and_labels.h>
#include <solomon/services/fetcher/lib/fetcher_shard.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/http/client/http.h>
#include <solomon/libs/cpp/limiter/limiter.h>

#include <solomon/protos/common/url_info.pb.h>

#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/monlib/encode/format.h>
#include <library/cpp/monlib/metrics/fwd.h>

#include <util/generic/maybe.h>
#include <util/string/builder.h>

namespace NSolomon::NFetcher {
    struct TDownloadEvents: private TEventSlot<EEventSpace::Fetcher, FS_DOWNLOAD> {
        enum {
            EvHttpDownload = SpaceBegin,
            EvHttpDownloadCompleted,
            End,
        };
        static_assert(End < SpaceEnd, "too many event types");
    };

    // because some clients return headers in non lookup-friendly container
    using THeaders = THashMap<TString, TString>;

    struct TDownloadRequest {
        TDownloadRequest(TString url, TString tsArgs = {}, THeaders headers = {}, ui64 respLimitBytes = 0, TInstant downloadStart = TInstant::Zero(), TString body = {}, bool isPost = false)
            : Url{std::move(url)}
            , TsArgs{std::move(tsArgs)}
            , Body{std::move(body)}
            , Headers{std::move(headers)}
            , ResponseSizeLimitBytes{respLimitBytes}
            , DownloadInstant{downloadStart}
            , IsPost{isPost}
        {
        }

        TString Url;
        TString TsArgs;
        TString Body;

        THeaders Headers;

        /// 0 means unlimited
        ui64 ResponseSizeLimitBytes{0};

        // enforce download start value in the response
        TInstant DownloadInstant;
        bool IsPost{false};
    };

    struct TEvDownloadCompleted: NActors::TEventLocal<TEvDownloadCompleted, TDownloadEvents::EvHttpDownloadCompleted> {
        IHttpClient::TResult Result;

        TInstant DownloadStart;
        TDuration Duration;
    };

    struct TFetcherActorConfig {
        IHttpClientPtr Client;
        TDuration Timeout{TDuration::Seconds(5)};
        TDuration ConnectTimeout{TDuration::Seconds(1)};
    };

    NActors::IActor* CreateHttpDownloadActor(TFetcherActorConfig conf, TDownloadRequest&& req, NActors::TActorId receiver);

} // namespace NSolomon::NFetcher
