#pragma once

#include <solomon/services/fetcher/lib/fetcher_shard.h>

namespace NSolomon::NFetcher {
    class TSimpleShard: public IFetcherShard, TMoveOnly {
    public:
        TSimpleShard(TShardConfigPtr shard, TClusterConfigPtr cluster, TServiceConfigPtr service, const TClusterNode& location = {});

        NDb::NModel::EPullProtocol Protocol() const override;
        ui16 Port() const override;
        const TShardId& Id() const override;
        TStringBuf ProjectId() const override;
        TStringBuf ServiceName() const override;

        TMaybeTvmId TvmId() const override;
        TStringBuf UrlPath() const override;
        TDuration FetchInterval() const override;
        i32 GridSec() const override;
        bool IsAddTsArgs() const override;
        bool IsUseFqdn() const override;
        bool IsPull() const override;
        bool IsValid() const override;
        ui32 MaxResponseSizeBytes() const override;
        ui32 MaxMetricsPerUrl() const override;
        const TClusterNode& Location() const override;
        TIntrusiveConstPtr<IFetcherCluster> Cluster() const override;

        bool IsEqual(const IFetcherShard& other) const override;
        EFetcherShardType Type() const override;
        TString ToString() const override;
        void DumpConfig(IOutputStream* out) const override;

    private:
        template <typename T, typename TGetter>
        std::optional<T> GetPullSetting(TGetter&& getter) const {
            if (auto* pull = std::get_if<NDb::NModel::TPullSettings>(&Shard_->ShardSettings.PullOrPush)) {
                if (auto val = getter(pull)) {
                    return val;
                }
            }
            if (auto* pull = std::get_if<NDb::NModel::TPullSettings>(&Cluster_->ShardSettings.PullOrPush)) {
                if (auto val = getter(pull)) {
                    return val;
                }
            }
            if (auto* pull = std::get_if<NDb::NModel::TPullSettings>(&Service_->ShardSettings.PullOrPush)) {
                if (auto val = getter(pull)) {
                    return val;
                }
            }
            return std::nullopt;
        }

    protected:
        TShardConfigPtr Shard_;
        TClusterConfigPtr Cluster_;
        TServiceConfigPtr Service_;
        TIntrusiveConstPtr<IFetcherCluster> FetcherCluster_;

        TClusterNode Location_;
        TShardId ShardId_;
    };
} // namespace NSolomon::NFetcher
