#include <solomon/services/fetcher/lib/fetcher_shard.h>
#include <solomon/services/fetcher/lib/host_groups/factory.h>
#include <solomon/services/fetcher/lib/host_groups/resolver_config.h>
#include <solomon/services/fetcher/testlib/db.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NTesting;
using namespace NSolomon::NFetcher;
using namespace NSolomon::NDb::NModel;
using namespace testing;

namespace {
    struct TMockHostResolverFactory: public IHostResolverFactory {
        IHostGroupResolverPtr CreateConductorGroupResolver(TConductorConfig) override {
            return nullptr;
        }

        IHostGroupResolverPtr CreateConductorTagResolver(TConductorConfig) override {
            return nullptr;
        }

        IHostGroupResolverPtr CreateHostPatternResolver(THostPatternConfig) override {
            return nullptr;
        }

        IHostGroupResolverPtr CreateHostUrlResolver(THostListUrlConfig) override {
            return nullptr;
        }

        IHostGroupResolverPtr CreateQloudResolver(TQloudConfig) override {
            return nullptr;
        }

        IHostGroupResolverPtr CreateYpResolver(TYpConfig) override {
            return nullptr;
        }

        IHostGroupResolverPtr CreateNetworkResolver(TNetworkConfig) override {
            return nullptr;
        }

        IHostGroupResolverPtr CreateNannyResolver(TNannyConfig) override {
            return nullptr;
        }

        IHostGroupResolverPtr CreateInstanceGroupResolver(TInstanceGroupConfig) override {
            return nullptr;
        }

        IHostGroupResolverPtr CreateAgentGroupResolver(TString, TVector<THostAndLabels>) override {
            return nullptr;
        }

        IHostGroupResolverPtr CreateYasmAgentGroupResolver(TVector<TString>, TVector<TString>) override {
            return nullptr;
        }

        IHostGroupResolverPtr CreateCloudDnsResolver(TString, TCloudDnsConfig) override {
            return nullptr;
        }

    };
}

bool IsSuccess(const NSolomon::TErrorOr<IHostGroupResolverPtr, NSolomon::TGenericError>& r) {
    return r.Success();
}

bool IsError(const NSolomon::TErrorOr<IHostGroupResolverPtr, NSolomon::TGenericError>& r) {
    return !IsSuccess(r);
}

TEST(TSimpleShardTest, CreateResolvers) {
    const TString conductorGroups{R"(
        [{"group": "group1", "labels" : ["type=test"]}, {"group": "group2", "labels": ["type=prod"]},
         {"group": "group3", "labels" : []}
        ]
    )"};

    auto shard = MakeAtomicShared<TShardConfig>(MakeShardConfig());
    auto service = MakeAtomicShared<TServiceConfig>(MakeServiceConfig());
    auto cluster = MakeAtomicShared<TClusterConfig>();
    cluster->ConductorGroups = conductorGroups;

    auto fetcherShard = CreateSimpleShard(shard, cluster, service);
    TMockHostResolverFactory factory;

    auto resolvers = fetcherShard.Cluster()->CreateResolvers(factory);
    ASSERT_THAT(resolvers, SizeIs(3));
    ASSERT_THAT(resolvers, Each(Truly(IsSuccess)));
}

TEST(TSimpleShardTest, CreateResolversFromBrokenConfig) {
    const TString conductorGroups{"broken"};

    auto shard = MakeAtomicShared<TShardConfig>(MakeShardConfig());
    auto service = MakeAtomicShared<TServiceConfig>(MakeServiceConfig());
    auto cluster = MakeAtomicShared<TClusterConfig>();
    cluster->ConductorGroups = conductorGroups;

    auto fetcherShard = CreateSimpleShard(shard, cluster, service);
    TMockHostResolverFactory factory;

    auto resolvers = fetcherShard.Cluster()->CreateResolvers(factory);
    ASSERT_THAT(resolvers, SizeIs(1));
    ASSERT_THAT(resolvers, Each(Truly(IsError)));
}

TEST(MakeAgentShardId, HappyPath) {
    TString providerId = "someProviderId";
    auto shard = CreateAgentShard(providerId, TDuration::Seconds(15), {});
    ASSERT_EQ(MakeAgentShardId(providerId), shard.Id().StrId());
}
