#include "agents.h"

#include <util/generic/algorithm.h>

#include <utility>

using namespace NThreading;

namespace NSolomon::NFetcher {
namespace {
    class TAgentGroupResolver: public IHostGroupResolver {
    public:
        TAgentGroupResolver(TString name, TVector<THostAndLabels> hosts, IUrlLocatorPtr locator)
            : Name_{std::move(name)}
            , Hosts_{std::move(hosts)}
            , Locator_{std::move(locator)}
        {
        }

        TAsyncResolveResult Resolve() noexcept override {
            TVector<THostAndLabels> result;
            CopyIf(Hosts_.begin(), Hosts_.end(), std::back_inserter(result),
                // TODO(ivanzhukov@): return true in the GLOBAL mode (or create a DEBUG mode or smth)
                [&] (auto&& h) { return Locator_->IsLocal(h); }
            );

            return MakeFuture<TResolveResult>(result);
        }

        const TString& Name() const override {
            return Name_;
        }

        std::optional<TString> CacheKey() const override {
            return std::nullopt;
        }

    private:
        TString Name_;
        TVector<THostAndLabels> Hosts_;
        IUrlLocatorPtr Locator_;
    };
} // namespace

    IHostGroupResolverPtr CreateAgentGroupResolver(TString projectId, TVector<THostAndLabels> hosts, IUrlLocatorPtr locator) {
        return new TAgentGroupResolver{std::move(projectId), std::move(hosts), std::move(locator)};
    }
} // namespace NSolomon::NFetcher
