#pragma once

#include "factory.h"
#include "host_resolver.h"
#include "host_and_labels.h"

namespace NSolomon::NFetcher {
    struct TWalleResolverConfig: THttpResolverConfig {
        using THttpResolverConfig::THttpResolverConfig;
        TWalleResolverConfig(IHttpClient* client, EDc dc)
            : THttpResolverConfig::THttpResolverConfig{client}
            , Dc{dc}
        {
        }

        TString WalleApiUrl{"https://api.wall-e.yandex-team.ru"};
        EDc Dc{EDc::UNKNOWN};
        TVector<TString> Tags;
    };

    IHostGroupResolverPtr CreateAgentGroupResolver(TString projectId, TVector<THostAndLabels> hosts, IUrlLocatorPtr locator);

    IHostGroupResolverPtr CreateYasmAgentGroupResolver(
        TWalleResolverConfig config,
        TConductorResolverConfig conductorConf,
        NMonitoring::TMetricRegistry& registry,
        IUrlLocatorPtr locator
    );

    IHostGroupResolverPtr CreateYasmAgentGroupResolver(
        TWalleResolverConfig config,
        NMonitoring::TMetricRegistry& registry,
        IUrlLocatorPtr locator
    );

    IHostGroupResolverPtr CreateYasmAgentHostsFileResolver(
            IUrlLocatorPtr,
            NMonitoring::TMetricRegistry* registry = nullptr);

    IHostGroupResolverPtr CreateYasmAgentHostsFileResolver(
            TString filePath,
            IUrlLocatorPtr,
            NMonitoring::TMetricRegistry* registry = nullptr);

} // namespace NSolomon::NFetcher
