#pragma once

#include "host_resolver.h"
#include "resolver_config.h"

#include <util/generic/vector.h>

namespace NSolomon::NFetcher {
    TVector<TConductorConfig> ParseConductorGroups(const TString& json);
    TVector<TConductorConfig> ParseConductorTags(const TString& json);
    TVector<THostPatternConfig> ParseHostPatternConfig(const TString& json);
    TVector<THostListUrlConfig> ParseHostUrlConfig(const TString& json);
    TVector<TQloudConfig> ParseQloudConfig(const TString& json);
    TVector<TYpConfig> ParseYpConfig(const TString& json);
    TVector<TNetworkConfig> ParseNetworkConfig(const TString& json);
    TVector<TNannyConfig> ParseNannyConfig(const TString& json);
    TVector<TInstanceGroupConfig> ParseInstanceGroupConfig(const TString& json);
    TVector<TCloudDnsConfig> ParseCloudDnsConfig(const TString& json);
} // namespace NSolomon::NFetcher
