#pragma once

#include "host_resolver_iface.h"
#include "resolver_config.h"

#include <solomon/services/fetcher/config/resolver_config.pb.h>
#include <solomon/services/fetcher/lib/cluster/cluster.h>

#include <solomon/libs/cpp/dns/dns.h>
#include <solomon/libs/cpp/grpc/client/client.h>
#include <solomon/libs/cpp/http/client/http.h>

#include <library/cpp/monlib/metrics/fwd.h>

#include <util/generic/ptr.h>
#include <optional>

namespace NSolomon::NCloud {
    struct IInstanceGroupClient;
    namespace NEnvoy {
        class IEndpointRpc;
    } // namespace NEnvoy
} // namespace NSolomon::NCloud

namespace NSolomon::NFetcher {
    class IUrlLocator: public TThrRefBase {
    public:
        virtual bool IsLocal(const THostAndLabels& hl) const = 0;
        virtual void SelectLocal(TVector<THostAndLabels>& hls) const = 0;
    };

    using IUrlLocatorPtr = TIntrusivePtr<IUrlLocator>;

    IUrlLocatorPtr FakeUrlLocator();
    IUrlLocatorPtr StubUrlLocator();

    class IHostResolverFactory: public TThrRefBase {
    public:
        virtual IHostGroupResolverPtr CreateConductorGroupResolver(struct TConductorConfig config) = 0;
        virtual IHostGroupResolverPtr CreateConductorTagResolver(struct TConductorConfig config) = 0;
        virtual IHostGroupResolverPtr CreateHostPatternResolver(struct THostPatternConfig config) = 0;
        virtual IHostGroupResolverPtr CreateHostUrlResolver(struct THostListUrlConfig config) = 0;
        virtual IHostGroupResolverPtr CreateQloudResolver(struct TQloudConfig config) = 0;
        virtual IHostGroupResolverPtr CreateYpResolver(struct TYpConfig config) = 0;
        virtual IHostGroupResolverPtr CreateNetworkResolver(struct TNetworkConfig config) = 0;
        virtual IHostGroupResolverPtr CreateNannyResolver(struct TNannyConfig config) = 0;
        virtual IHostGroupResolverPtr CreateInstanceGroupResolver(struct TInstanceGroupConfig config) = 0;
        virtual IHostGroupResolverPtr CreateAgentGroupResolver(TString name, TVector<THostAndLabels> hosts) = 0;
        virtual IHostGroupResolverPtr CreateYasmAgentGroupResolver(TVector<TString> walleTags, TVector<TString> conductorTags) = 0;
        virtual IHostGroupResolverPtr CreateCloudDnsResolver(TString projectId, struct TCloudDnsConfig config) = 0;
    };

    using IHostResolverFactoryPtr = TIntrusivePtr<IHostResolverFactory>;

    struct THostResolverFactoryConfig {
        NMonitoring::TMetricRegistry& Registry;
        const TClusterInfo& ClusterInfo;
        IDnsClientPtr DnsClient;
        IHttpClientPtr HttpClient;
        TConductorClientConfig ConductorConfig;
        TString YpToken;
        TIntrusivePtr<NCloud::IInstanceGroupClient> InstanceGroupClient;
        TIntrusivePtr<IUrlLocator> UrlLocator = FakeUrlLocator();
        std::map<ECloudEnv, TStringBuf> EnvoyAddresses;
        std::shared_ptr<IClusterRpc<NCloud::NEnvoy::IEndpointRpc>> EnvoyRpc;
    };

    IHostResolverFactoryPtr CreateHostResolverFactory(THostResolverFactoryConfig conf);
} // namespace NSolomon::NFetcher
