#include <util/string/builder.h>

namespace NSolomon::NFetcher {
    using namespace NMonitoring;

    THttpResolverBase::TCounters::TCounters(TStringBuf source, TMetricRegistry& registry)
        : Requests{registry.Rate({{"sensor", "resolver.requestRate"}, {"source", source}})}
        , Success{registry.Rate({{"sensor", "resolver.requests"}, {"code", "2xx"}, {"source", source}})}
        , ClientError{registry.Rate({{"sensor", "resolver.requests"}, {"code", "4xx"}, {"source", source}})}
        , ServerError{registry.Rate({{"sensor", "resolver.requests"}, {"code", "5xx"}, {"source", source}})}
    {
    }

    void THttpResolverBase::TCounters::StartRequest() {
        Requests->Inc();
    }

    void THttpResolverBase::TCounters::CompleteRequest(HttpCodes code) {
        if (code == HTTP_OK) {
            Success->Inc();
        } else if (IsUserError(code)) {
            ClientError->Inc();
        } else if (IsServerError(code)) {
            ServerError->Inc();
        }
    }
} // namespace NSolomon::NFetcher
