#include "http_counters.h"

#include <library/cpp/monlib/metrics/metric_registry.h>

#include <util/string/builder.h>

namespace NSolomon::NFetcher {
    using namespace NMonitoring;

    THttpCounters::THttpCounters(TStringBuf source, TMetricRegistry& registry)
        : Requests{registry.Rate({{"sensor", "resolver.requestRate"}, {"source", source}})}
        , Success{registry.Rate({{"sensor", "resolver.requests"}, {"code", "2xx"}, {"source", source}})}
        , ClientError{registry.Rate({{"sensor", "resolver.requests"}, {"code", "4xx"}, {"source", source}})}
        , ServerError{registry.Rate({{"sensor", "resolver.requests"}, {"code", "5xx"}, {"source", source}})}
        , UnknownError{registry.Rate({{"sensor", "resolver.requests"}, {"code", "unknown"}, {"source", source}})}
    {
    }

    void THttpCounters::StartRequest() {
        Requests->Inc();
    }

    void THttpCounters::CompleteRequest(HttpCodes code) {
        if (code == HTTP_OK) {
            Success->Inc();
        } else if (IsUserError(code)) {
            ClientError->Inc();
        } else if (IsServerError(code)) {
            ServerError->Inc();
        }
    }

    void THttpCounters::CompleteRequestFailure() {
        UnknownError->Inc();
    }
} // namespace NSolomon::NFetcher
