#pragma once

#include <library/cpp/http/misc/httpcodes.h>
#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon::NFetcher {
    struct THttpCounters {
        THttpCounters(TStringBuf source, NMonitoring::TMetricRegistry& registry);

        void StartRequest();
        void CompleteRequest(HttpCodes code);
        void CompleteRequestFailure();

        NMonitoring::TRate* Requests;
        NMonitoring::TRate* Success;
        NMonitoring::TRate* ClientError;
        NMonitoring::TRate* ServerError;
        NMonitoring::TRate* UnknownError;
    };
} // namespace NSolomon::NFetcher
