#include "host_resolver.h"

#include <library/cpp/ipmath/ipmath.h>

namespace NSolomon::NFetcher {
    using namespace NThreading;

    namespace {

        class TNetworkResolver: public IHostGroupResolver {
        public:
            TNetworkResolver(TNetworkResolverConfig conf)
                : Config_{std::move(conf)}
                , Name_{TStringBuilder() << "network:" << Config_.ClusterConfig.Network}
            {
            }

            TAsyncResolveResult Resolve() noexcept override {
                TUrls result;

                const auto networkStr = Config_.ClusterConfig.Network;
                auto maybeRange = TIpAddressRange::TryFromString(networkStr);
                if (!maybeRange) {
                    return MakeFuture<TResolveResult>(TResolveError{TStringBuilder() << "Failed to pase " << networkStr << " as an IP address range"});
                }

                auto&& range = *maybeRange;

                auto& maybePort = Config_.ClusterConfig.Port;
                range.ForEach([&] (auto&& addr) {
                    auto& hostAndLabels = result.emplace_back(addr, Config_.ClusterConfig.Labels);

                    if (maybePort) {
                        hostAndLabels.Port = *maybePort;
                    }
                });

                // this is a single address
                if (result.size() == 1) {
                    return MakeFuture<TResolveResult>(result);
                }

                if (!result.empty()) {
                    result.erase(result.begin());
                }

                if (!result.empty()) {
                    result.pop_back();
                }

                return MakeFuture<TResolveResult>(result);
            }

            const TString& Name() const override {
                return Name_;
            }

            std::optional<TString> CacheKey() const override {
                return {};
            }


        private:
            TNetworkResolverConfig Config_;
            const TString Name_;
        };
    } // namespace

    IHostGroupResolverPtr CreateNetworkResolver(TNetworkResolverConfig conf) {
        return MakeIntrusive<TNetworkResolver>(std::move(conf));
    }
} // namespace NSolomon::NFetcher
