#include "host_resolver.h"
#include "host_resolver_iface.h"

namespace NSolomon::NFetcher {
namespace {
    using namespace NThreading;

    class TQloudResolver: public IHostGroupResolver {
    public:
        explicit TQloudResolver(TQloudResolverConfig config)
            : Config_{std::move(config)}
            , ComponentUrl_{MakeComponentUrl(Config_)}
            , Name_{TStringBuilder() << "qloud-group:" + ComponentUrl_}
            , Dns_{Config_.DnsClient}
        {
        }

        TAsyncResolveResult Resolve() noexcept override {
            auto& c = Config_.ClusterConfig;

            const auto isValid = c.Component && c.Application && c.Project && c.Environment && c.Deployment;

            if (!isValid) {
                return MakeFuture<TResolveResult>(TResolveError{TStringBuilder() << "All component parts must be specified: " << ComponentUrl_});
            }

            TIntrusivePtr self{this};
            return Dns_->GetSrvRecords(ComponentUrl_).Apply([self] (auto f) {
                try {
                    auto srvRecords = f.ExtractValue();
                    TUrls result;
                    for (auto& record: srvRecords) {
                        result.push_back(THostAndLabels::FromString(
                            std::move(record.Host), self->Config_.ClusterConfig.Labels)
                        );
                    }

                    return TResolveResult::FromValue(std::move(result));
                } catch (...) {
                    return TResolveResult::FromError(
                        CurrentExceptionMessage(), TResolveError::Transient
                    );
                }
            });
        }

        const TString& Name() const override {
            return Name_;
        }

        static TString MakeComponentUrl(const TQloudResolverConfig& config) {
            auto& c = config.ClusterConfig;

            return TStringBuilder()
                << c.Component << "." << c.Environment << "." << c.Application << "."
                << c.Project << "." << c.Deployment << ".qloud-d.yandex.net.";
        }

    private:
        TQloudResolverConfig Config_;
        const TString ComponentUrl_;
        const TString Name_;
        IDnsClientPtr Dns_;
    };

} // namespace
    IHostGroupResolverPtr CreateQloudResolver(TQloudResolverConfig config) {
        return new TQloudResolver{std::move(config)};
    }
} // namespace NSolomon::NFetcher
