#include "resolver_config.h"

#include <util/string/cast.h>

using NSolomon::NFetcher::ECloudEnv;

template <>
void Out<ECloudEnv>(IOutputStream& out, ECloudEnv env) {
    switch (env) {
        case ECloudEnv::UNKNOWN:
            out << "UNKNOWN";
            break;
        case ECloudEnv::PREPROD:
            out << "PREPROD";
            break;
        case ECloudEnv::PROD:
            out << "PROD";
            break;
        case ECloudEnv::HWLAB:
            out << "HWLAB";
            break;
        case ECloudEnv::TESTING:
            out << "TESTING";
            break;
        case ECloudEnv::ISRAEL:
            out << "ISRAEL";
            break;
    }
}

template <>
ECloudEnv FromStringImpl<ECloudEnv>(const char* data, size_t len) {
    ECloudEnv env;
    Y_ENSURE(TryFromString(data, len, env));
    return env;
}

template <>
bool TryFromStringImpl<ECloudEnv>(const char* data, size_t len, ECloudEnv& env) {
    TStringBuf str{data, len};
    if (str == "PROD" || str == "prod") {
        env = ECloudEnv::PROD;
        return true;
    } else if (str == "PREPROD" || str == "preprod") {
        env = ECloudEnv::PREPROD;
        return true;
    } else if (str == "HWLAB" || str == "hwlab") {
        env = ECloudEnv::HWLAB;
        return true;
    } else if (str == "TESTING" || str == "testing") {
        env = ECloudEnv::TESTING;
        return true;
    } else if (str == "ISRAEL" || str == "israel") {
        env = ECloudEnv::ISRAEL;
        return true;
    } else if (str == "UNKNOWN" || str == "unknown") {
        env = ECloudEnv::UNKNOWN;
        return true;
    }
    return false;
}

using NSolomon::NFetcher::ENannyEnv;

template <>
void Out<ENannyEnv>(IOutputStream& out, ENannyEnv env) {
    switch (env) {
        case ENannyEnv::PRODUCTION:
            out << "PRODUCTION";
            break;
        case ENannyEnv::ADMIN:
            out << "ADMIN";
            break;
    }
}

template <>
ENannyEnv FromStringImpl<ENannyEnv>(const char* data, size_t len) {
    ENannyEnv env;
    Y_ENSURE(TryFromString(data, len, env));
    return env;
}

template <>
bool TryFromStringImpl<ENannyEnv>(const char* data, size_t len, ENannyEnv& env) {
    TStringBuf str{data, len};
    if (str == "PRODUCTION" || str == "production") {
        env = ENannyEnv::PRODUCTION;
        return true;
    } else if (str == "ADMIN" || str == "admin") {
        env = ENannyEnv::ADMIN;
        return true;
    }
    return false;
}
