#pragma once

#include <library/cpp/monlib/metrics/labels.h>

#include <optional>
#include <utility>

namespace NSolomon::NFetcher {
    struct TConductorConfig {
        TConductorConfig(TString name, NMonitoring::TLabels labels = {})
            : Labels{std::move(labels)}
            , Name{std::move(name)}
        {
        }

        NMonitoring::TLabels Labels;
        TString Name;
    };

    struct THostPatternConfig {
        THostPatternConfig(TString pattern, TString ranges, NMonitoring::TLabels labels = {}, TString dc = {})
            : Labels{std::move(labels)}
            , Pattern{std::move(pattern)}
            , Ranges{std::move(ranges)}
            , Dc{std::move(dc)}
        {
        }

        NMonitoring::TLabels Labels;
        TString Pattern;
        TString Ranges;
        TString Dc;
    };

    struct THostListUrlConfig {
        THostListUrlConfig(TString url, NMonitoring::TLabels labels = {}, bool ignorePorts = false)
            : Labels{std::move(labels)}
            , Url{std::move(url)}
            , IgnorePorts{ignorePorts}
        {
        }

        NMonitoring::TLabels Labels;
        TString Url;
        bool IgnorePorts{false};
    };

    struct TQloudConfig {
        TQloudConfig() = default;

        NMonitoring::TLabels Labels;
        TString Component;
        TString Environment;
        TString Application;
        TString Project;
        TString Deployment;
    };

    struct TYpPodSet {
        TString Id;
        bool operator==(const TYpPodSet& other) const = default;
    };

    struct TYpEndpointSet {
        TString Id;
        bool operator==(const TYpEndpointSet& other) const = default;
    };

    struct TYpLabel {
        TString Value;
        TString TvmLabel;
        bool operator==(const TYpLabel& other) const = default;
    };

    struct TYpConfig {
        std::variant<TYpPodSet, TYpEndpointSet, TYpLabel> Type;
        TString Cluster;
        NMonitoring::TLabels Labels;
        bool operator==(const TYpConfig& other) const = default;
    };

    struct TNetworkConfig {
        TString Network;
        std::optional<ui16> Port;
        NMonitoring::TLabels Labels;
    };

    enum class ENannyEnv {
        PRODUCTION,
        ADMIN,
    };

    struct TNannyConfig {
        TString Service;
        NMonitoring::TLabels Labels;
        bool UseFetchedPort{false};
        ENannyEnv Env{ENannyEnv::PRODUCTION};
        ui16 PortShift{0};
        TVector<TString> CfgGroups;
    };

    struct TInstanceGroupConfig {
        TString GroupId;
        TString FolderId;
        NMonitoring::TLabels Labels;
    };

    enum class ECloudEnv {
        UNKNOWN,
        PREPROD,
        PROD,
        HWLAB,
        TESTING,
        ISRAEL,
    };

    struct TCloudDnsConfig {
        ECloudEnv Env{ECloudEnv::UNKNOWN};
        TString Name;
        NMonitoring::TLabels Labels;

        bool operator==(const TCloudDnsConfig&) const = default;
    };
} // namespace NSolomon::NFetcher
