#include <solomon/services/fetcher/lib/host_groups/agents.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace testing;
using namespace NSolomon::NFetcher;

TEST(TAgentGroupTest, HostsAreFiltered) {
    struct TLocator: IUrlLocator {
        bool IsLocal(const THostAndLabels& host) const override {
            return host.Host.StartsWith("my");
        }

        void SelectLocal(TVector<THostAndLabels>& hls) const override {
            EraseIf(hls, [this] (auto&& hl) {
                return !IsLocal(hl);
            });
        }
    };

    auto locator = MakeIntrusive<TLocator>();

    TVector<THostAndLabels> hosts{
        {"my.host1"},
        {"my.host2"},
        {"not.my.host1"}
    };

    auto resolver = CreateAgentGroupResolver("foo", hosts, locator);
    ASSERT_THAT(resolver->Name(), Eq("foo"));
    auto r = resolver->Resolve().ExtractValueSync();
    ASSERT_THAT(r.Success(), true);
    ASSERT_THAT(r.Value(), UnorderedElementsAre(
        THostAndLabels{"my.host1"},
        THostAndLabels{"my.host2"}
    ));
}
