#pragma once

#include <solomon/services/fetcher/lib/events.h>
#include <solomon/services/fetcher/lib/shard_assignments/assignments.h>

#include <solomon/libs/cpp/actors/events/common.h>
#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/cluster_map/cluster.h>
#include <solomon/libs/cpp/clients/ingestor/ingestor_client.h>

#include <library/cpp/actors/core/actor_bootstrapped.h>

#include <util/datetime/base.h>

namespace NSolomon::NFetcher {

class TIngestorRequesterEvents: private TEventSlot<EEventSpace::Fetcher, FS_INGESTOR> {
private:
    enum {
        RequestAssignments = SpaceBegin,
        AssignmentsResponse,
        End,
    };

    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TRequestAssignments: public NActors::TEventLocal<TRequestAssignments, RequestAssignments> {
    };

    struct TAssignmentsResponse: public NActors::TEventLocal<TAssignmentsResponse, AssignmentsResponse> {
        TVector<TShardAssignment> Assignments;

        explicit TAssignmentsResponse(TVector<TShardAssignment> assignments)
            : Assignments{std::move(assignments)}
        {}
    };
};

NActors::IActor* CreateIngestorClusterRequester(
        IClusterMapPtr cluster,
        NSolomon::NIngestor::IIngestorClusterClientPtr clients,
        TDuration updateInterval
);

} // namespace NSolomon::NFetcher
