#include "helper.h"

#include <util/generic/algorithm.h>

namespace NSolomon::NFetcher {
    void TLocatorHelper::SetAssignments(NCoordination::TAssignments&& assn) {
        auto&& slices = assn.Slices();
        const auto isSorted = std::is_sorted(slices.begin(), slices.end());
        Y_VERIFY_DEBUG(isSorted);
        if (!isSorted) {
            auto sortedSlices = assn.Slices();
            Sort(sortedSlices);
            CurrentAssignments_ = {assn.NodeId(), std::move(sortedSlices)};
        } else {
            CurrentAssignments_ = std::move(assn);
        }
    }

    bool TLocatorHelper::IsEmpty() const {
        return CurrentAssignments_.Slices().empty();
    }

    bool TLocatorHelper::IsLocal(ui64 hash) const {
        const auto& slices = CurrentAssignments_.Slices();
        if (slices.empty()) {
            return false;
        }

        auto lower = LowerBoundBy(slices.begin(), slices.end(), hash, [] (auto&& slice) {
            return slice.first;
        });

        auto contains = [&] (auto it) {
            return (it->first <= hash) && (it->second >= hash);
        };

        if (lower == slices.begin()) {
            return contains(lower);
        } else if (lower != slices.end() && contains(lower)) {
            return true;
        }

        --lower;
        return contains(lower);
    }
} // namespace NSolomon::NFetcher
