#pragma once

#include <solomon/services/fetcher/config/load_balancer_config.pb.h>
#include <solomon/services/fetcher/lib/host_groups/factory.h>
#include <solomon/services/fetcher/lib/shard_manager/shard_resolver.h>

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/coordination/load_balancer/load_balancer.h>

#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon::NDb {
    class TYdbConfig;
} // namespace NSolomon::NDb


namespace NSolomon::NFetcher {
    class IAssignmentsConsumer: public IUrlLocator {
    public:
        virtual void OnAssignments(NSolomon::NCoordination::TAssignments&& assn) = 0;
    };

    using IAssignmentsConsumerPtr = TIntrusivePtr<IAssignmentsConsumer>;

    NActors::IActor* CreateLoadBalancerActor(
            NActors::TActorId balancerId,
            NActors::TActorId resolverId,
            IFetcherClusterPtr cluster,
            IAssignmentsConsumerPtr consumer);

    IDistributedLockPtr CreateLock(
        const NYdb::TDriver& driver,
        const TLockConfig& lockConf
    );

    NCoordination::TLoadBalancerConfig CreateLoadBalancerConfig(
        NMonitoring::IMetricFactory&,
        const TLoadBalancerConfig& protoConf
    );

    IAssignmentsConsumerPtr CreateAssignmentsConsumer();

} // namespace NSolomon::NFetcher
