#include <solomon/services/fetcher/lib/load_balancer/helper.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NCoordination;
using namespace NSolomon::NFetcher;

class TLocatorTest: public ::testing::Test {
protected:
    TLocatorHelper Helper_;
};

TEST_F(TLocatorTest, Init) {
    ASSERT_TRUE(Helper_.IsEmpty());
    ASSERT_FALSE(Helper_.IsLocal(0));
    ASSERT_FALSE(Helper_.IsLocal(100));
    ASSERT_FALSE(Helper_.IsLocal(Max<size_t>()));
}

TEST_F(TLocatorTest, AssignmentsCanBeSet) {
    TAssignments assn{0, {{1, 100}}};
    Helper_.SetAssignments(std::move(assn));

    ASSERT_FALSE(Helper_.IsEmpty());
    ASSERT_FALSE(Helper_.IsLocal(0));
    ASSERT_TRUE(Helper_.IsLocal(1));
    ASSERT_TRUE(Helper_.IsLocal(50));
    ASSERT_TRUE(Helper_.IsLocal(100));
    ASSERT_FALSE(Helper_.IsLocal(102));
    ASSERT_FALSE(Helper_.IsLocal(Max<size_t>()));
}

TEST_F(TLocatorTest, MultipleSlices) {
    TAssignments assn{0, {
            {1, 100},
            {102, 500},
            {Max<ui64>() - 100, Max<ui64>()}
    }};

    Helper_.SetAssignments(std::move(assn));
    ASSERT_FALSE(Helper_.IsLocal(0));
    ASSERT_TRUE(Helper_.IsLocal(1));
    ASSERT_TRUE(Helper_.IsLocal(50));
    ASSERT_TRUE(Helper_.IsLocal(100));
    ASSERT_FALSE(Helper_.IsLocal(101));
    ASSERT_TRUE(Helper_.IsLocal(102));
    ASSERT_TRUE(Helper_.IsLocal(Max<size_t>()));
    ASSERT_FALSE(Helper_.IsLocal(Max<size_t>() - 101));
    ASSERT_TRUE(Helper_.IsLocal(Max<size_t>() - 100));
}
