#pragma once

#include <solomon/services/fetcher/lib/events.h>
#include <solomon/services/fetcher/lib/sink/sink.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/auth/core/authenticator.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

namespace NSolomon::NFetcher {

struct TAuthGatekeeperEvents: private TEventSlot<EEventSpace::Fetcher, FS_AUTH> {
    enum {
        Examine = SpaceBegin,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

    struct TExamine: NActors::TEventLocal<TExamine, Examine> {
        std::unique_ptr<TShardData> ShardData;
        TString Provider;
        /**
         * IAM token or TVM Service Ticket
         */
        TString Credentials;
        TString Url;

        TExamine(TShardData shardData, TString provider, TString credentials, TString url)
            : ShardData{std::make_unique<TShardData>(std::move(shardData))}
            , Provider{std::move(provider)}
            , Credentials{std::move(credentials)}
            , Url{std::move(url)}
        {
        }
    };
};

/**
 * For now, used only in Cloud
 *
 * An actor whose job is to:
 * 1) receive data that was previously downloaded from a url,
 * 2) check that
 *   a) the token given with the data is mapped to a service account and
 *   b) this service account is matched to the service provider,
 * 3) check that this service account does have the write permission to the specified folder,
 * 4) and only then pass the data to the sink
 */
std::unique_ptr<NActors::IActor> CreateIamAuthGatekeeper(
        NActors::TActorId accessService,
        NActors::TActorId configUpdater,
        NActors::TActorId sink,
        TDuration unusedRecordsTtl,
        TDuration cacheDuration,
        TDuration gcInterval,
        bool dontTakeAuthorizationIntoAccount,
        std::shared_ptr<NMonitoring::TMetricRegistry> registry);

std::unique_ptr<NActors::IActor> CreateTvmAuthGatekeeper(
        NAuth::IAuthenticatorPtr tvmAuthenticator,
        NActors::TActorId configUpdater,
        NActors::TActorId sink,
        TDuration unusedRecordsTtl,
        TDuration cacheDuration,
        TDuration gcInterval,
        std::shared_ptr<NMonitoring::TMetricRegistry> registry);

} // namespace NSolomon::NFetcher
