#include <solomon/services/fetcher/lib/queue/queue.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NFetcher;

TEST(TShardQueueTest, ShardQueueUrlLimit) {
    TQueueEntry entry;
    entry.Url = "foo";

    constexpr auto URL_LIMIT = 10;
    TShardQueue q{URL_LIMIT, 0, nullptr};
    for (auto i = 0; i < URL_LIMIT; ++i) {
        auto e = entry;
        ASSERT_TRUE(q.Push(std::move(e)));
    }

    {
        auto e = entry;
        ASSERT_TRUE(!q.Push(std::move(e)));
    }

    {
        auto e = entry;
        e.Url = "bar";
        ASSERT_TRUE(q.Push(std::move(e)));
    }

    {
        q.Pop();
        auto e = entry;
        ASSERT_TRUE(q.Push(std::move(e)));
    }
}

TEST(TShardQueueTest, ShardQueueUrlLimitCleared) {
    TQueueEntry entry;
    entry.Url = "foo";

    constexpr auto URL_LIMIT = 10;
    TShardQueue q{URL_LIMIT, 0, nullptr};
    for (auto i = 0; i < URL_LIMIT; ++i) {
        auto e = entry;
        ASSERT_TRUE(q.Push(std::move(e)));
    }

    {
        auto e = entry;
        ASSERT_TRUE(!q.Push(std::move(e)));
    }

    q.Clear();
    {
        auto e = entry;
        ASSERT_TRUE(q.Push(std::move(e)));
    }
}

TEST(TShardQueueTest, ShardQueueSingleUrlGlobalLimit) {
    constexpr auto GLOBAL_LIMIT = 10;
    TShardQueue q{0, GLOBAL_LIMIT, nullptr};

    for (auto i = 0; i < GLOBAL_LIMIT; ++i) {
        TQueueEntry e;
        e.Url = TStringBuilder() << "url" << i;
        ASSERT_TRUE(q.Push(std::move(e)));
    }

    TQueueEntry e;
    e.Url = "foo";

    ASSERT_TRUE(!q.Push(std::move(e)));
}
