#pragma once

#include <solomon/libs/cpp/solomon_env/dc.h>

#include <util/folder/path.h>
#include <util/generic/serialized_enum.h>
#include <util/generic/strbuf.h>

#include <optional>

class TIpv6Address;
class IOutputStream;

namespace NSolomon {
    class IDcMatcher {
    public:
        virtual ~IDcMatcher() = default;

        virtual EDc DcByAddress(const TIpv6Address&) const = 0;

        virtual void Dump(IOutputStream& os) const = 0;

        virtual size_t Size() const = 0;
    };

    using IDcMatcherPtr = THolder<IDcMatcher>;

    IDcMatcherPtr CreateIpv6Matcher(TStringBuf data);

    IDcMatcherPtr CreateIpv6Matcher(const TFsPath& file);

    IDcMatcherPtr CreateDefaultIpv6Matcher();

} // namespace NSolomon
