#pragma once

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/services/fetcher/lib/events.h>
#include <solomon/libs/cpp/http/client/curl/client.h>
#include <solomon/libs/cpp/solomon_env/dc.h>

#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/ipv6_address/ipv6_address.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

#include <util/folder/path.h>

namespace NSolomon::NFetcher {

struct TRackTablesEvents: private TEventSlot<EEventSpace::Fetcher, FS_RACK_TABLES> {
    enum {
        DcResolve = SpaceBegin,
        DcResult,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

    struct TDcResolve: NActors::TEventLocal<TDcResolve, DcResolve> {
        const TIpv6Address Address;

        explicit TDcResolve(TIpv6Address address) noexcept
            : Address{address}
        {
        }
    };

    struct TDcResult: NActors::TEventLocal<TDcResult, DcResult> {
        const EDc Dc;

        explicit TDcResult(EDc dc) noexcept
            : Dc{dc}
        {
        }
    };
};

struct TRackTablesActorConf {
    TDuration RefreshInterval;
    TDuration ConnectTimeout;
    TDuration ReadTimeout;
    ui8 Retries;
    TString Url;
    TFsPath FileCache;
    IHttpClientPtr HttpClient;
    NMonitoring::TMetricRegistry& Registry;
};

/**
 * Creates an actor which defines Dc by ipv6.
 *
 * Actor receives TEvDcResolve event with ipv6 and returns TEvDcResult event with Dc.
 *
 * Also, every RefreshInterval actor downloads ip database
 * from HTTP-endpoint defined by the given URL
 *
 * @param conf   config, contains RefreshInterval, Url and FileCache
 */
std::unique_ptr<NActors::IActor> CreateRackTablesActor(const TRackTablesActorConf&);

std::unique_ptr<NActors::IActor> CreateRacktablesActorStub(NMonitoring::TMetricRegistry&);

} // namespace NSolomon::NFetcher
