#include <solomon/services/fetcher/lib/racktables/racktables_actor.h>
#include <solomon/services/fetcher/testlib/actor_system.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NActors;
using namespace NSolomon::NFetcher;
using namespace NSolomon::NTesting;
using namespace NSolomon;

class TRacktablesActorStubTest: public ::testing::Test {
protected:
    TRacktablesActorStubTest()
        : Registry_({{"common", "label"}})
    {
    }

    void SetUp() override {
        Runtime_ = TTestActorRuntime::CreateInited();

        Resolver_ = Runtime_->Register(CreateRacktablesActorStub(Registry_));
        Edge_ = Runtime_->AllocateEdgeActor();
    }

protected:
    THolder<TTestActorRuntime> Runtime_;
    TActorId Resolver_;
    TActorId Edge_;
    NMonitoring::TMetricRegistry Registry_;
};

TEST_F(TRacktablesActorStubTest, Simple) {
    bool ok{};
    {
        const TIpv6Address testIpSas = TIpv6Address::FromString("2a02:6b8:c08:5795:0:4c7d:fd8d:d36d", ok);
        Runtime_->Send(new IEventHandle{Resolver_, Edge_, new TRackTablesEvents::TDcResolve{testIpSas}});
        auto ev = Runtime_->GrabEdgeEvent<TRackTablesEvents::TDcResult>(Edge_);
        ASSERT_EQ(ev->Get()->Dc , EDc::UNKNOWN);
    }
    {
        const TIpv6Address testIpVla = TIpv6Address::FromString("2a02:6b8:c1d:1380:2a02:6b8:c1d:1380", ok);
        Runtime_->Send(new IEventHandle{Resolver_, Edge_, new TRackTablesEvents::TDcResolve{testIpVla}});
        auto ev = Runtime_->GrabEdgeEvent<TRackTablesEvents::TDcResult>(Edge_);
        ASSERT_EQ(ev->Get()->Dc , EDc::UNKNOWN);
    }
    {
        const TIpv6Address testIpMan = TIpv6Address::FromString("2a02:6b8:b082:15:15:b082:6b8:2a02", ok);
        Runtime_->Send(new IEventHandle{Resolver_, Edge_, new TRackTablesEvents::TDcResolve{testIpMan}});
        auto ev = Runtime_->GrabEdgeEvent<TRackTablesEvents::TDcResult>(Edge_);
        ASSERT_EQ(ev->Get()->Dc , EDc::UNKNOWN);
    }
    {
        const TIpv6Address testIpUnknown = TIpv6Address::FromString("2a00:1450:4010:c0b::71", ok);
        Runtime_->Send(new IEventHandle{Resolver_, Edge_, new TRackTablesEvents::TDcResolve{testIpUnknown}});
        auto ev = Runtime_->GrabEdgeEvent<TRackTablesEvents::TDcResult>(Edge_);
        ASSERT_EQ(ev->Get()->Dc , EDc::UNKNOWN);
    }
}
