#pragma once

#include <solomon/services/fetcher/lib/events.h>
#include <solomon/services/fetcher/lib/id.h>
#include <solomon/services/fetcher/lib/cluster/cluster.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>

#include <library/cpp/actors/core/actorid.h>
#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon::NFetcher {
    struct TRouterState {
        struct TBacklog {
            TShardId ShardId;
            ui64 MemorySize{0};
            ui64 EntrySize{0};
            bool IsFull{false};
        };

        struct TShard {
            TShardId Id;
            TClusterNode Location;
        };

        // known coremons in the cluster
        TVector<TClusterNode> Peers;

        // state of the postponed queues
        TVector<TBacklog> Backlogs;

        // shard map as seen by this fetcher
        TVector<TShard> Shards;
    };

    struct TRouterEvents: private TEventSlot<EEventSpace::Fetcher, FS_ROUTER> {
        enum {
            EvRouterStatePeersRequest = SpaceBegin,
            EvRouterStateBacklogsRequest,
            EvRouterStateShardsRequest,
            EvRouterStatePeersResponse,
            EvRouterStateBacklogsResponse,
            EvRouterStateShardsResponse,

            EvUnknownShard,
            EvShardCreated,
            End,
        };
        static_assert(End < SpaceEnd, "too many event types");
    };

    struct TEvRouterStatePeersRequest: NActors::TEventLocal<TEvRouterStatePeersRequest, TRouterEvents::EvRouterStatePeersRequest> {
    };

    struct TEvRouterStateBacklogsRequest: NActors::TEventLocal<TEvRouterStateBacklogsRequest, TRouterEvents::EvRouterStateBacklogsRequest> {
    };

    struct TEvRouterStateShardsRequest: NActors::TEventLocal<TEvRouterStateShardsRequest, TRouterEvents::EvRouterStateShardsRequest> {
    };

    struct TEvRouterStatePeersResponse: NActors::TEventLocal<TEvRouterStatePeersResponse, TRouterEvents::EvRouterStatePeersResponse> {
        TEvRouterStatePeersResponse(TVector<TClusterNode>&& peers)
            : Peers{std::move(peers)}
        {
        }

        TVector<TClusterNode> Peers;
    };

    struct TEvRouterStateBacklogsResponse: NActors::TEventLocal<TEvRouterStateBacklogsResponse, TRouterEvents::EvRouterStateBacklogsResponse> {
        TEvRouterStateBacklogsResponse(TVector<TRouterState::TBacklog>&& backlogs)
            : Backlogs{std::move(backlogs)}
        {
        }

        TVector<TRouterState::TBacklog> Backlogs;
    };

    struct TEvRouterStateShardsResponse: NActors::TEventLocal<TEvRouterStateShardsResponse, TRouterEvents::EvRouterStateShardsResponse> {
        TEvRouterStateShardsResponse(TVector<TRouterState::TShard>&& shards)
            : Shards{std::move(shards)}
        {
        }

        TVector<TRouterState::TShard> Shards;
    };

    struct TRouterActorConf {
        ui32 UrlBacklogLimit = 5;
        ui32 ShardBacklogLimit = 5 * 1024;
        THashMap<TClusterNode, NActors::TActorId> Peers;
        NActors::TActorId UnknownShardHandlerId;
        const IClusterMap* Cluster{nullptr};
    };

    NActors::IActor* CreateRouterActor(TRouterActorConf conf, NMonitoring::TMetricRegistry& registry);
    NActors::TActorId MakeRouterServiceId();
} // namespace NSolomon::NFetcher
