#pragma once

#include "router.h"

#include <solomon/services/fetcher/lib/queue/queue.h>
#include <solomon/services/fetcher/lib/sink/sink.h>
#include <solomon/services/fetcher/lib/data_sink/processing_client.h>

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/shard_key/shard_key.h>

#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NFetcher {
    class TUnknownShardBacklog {
    public:
        TUnknownShardBacklog() = default;

        bool Add(TShardKey key, TEvSinkWrite&& ev) {
            if (auto* queue = Queues_.FindPtr(key)) {
                return queue->Push(std::move(ev), NActors::TActorId{});
            } else {
                auto [it, _] = Queues_.emplace(
                    std::piecewise_construct,
                    std::forward_as_tuple(key),
                    std::forward_as_tuple(2, 1000, CreateFakeCounters())
                );

                return it->second.Push(std::move(ev), NActors::TActorId{});
            }
        }

        void Drop(const TShardKey& key) {
            Queues_.erase(key);
        }

        TVector<TQueueEntry> Extract(const TShardKey& key) {
            if (auto* queue = Queues_.FindPtr(key)) {
                TVector<TQueueEntry> entries;
                while (!queue->IsEmpty()) {
                    entries.emplace_back(queue->Pop());
                }

                Queues_.erase(key);
                return entries;
            }

            return {};
        }

    private:
        THashMap<TShardKey, TShardQueue> Queues_;
    };

    struct TEvUnknownShard: public NActors::TEventLocal<TEvUnknownShard, TRouterEvents::EvUnknownShard> {
        TEvUnknownShard(TShardKey key, TString createdBy = {})
            : ShardKey{std::move(key)}
            , CreatedBy{std::move(createdBy)}
        {
        }

        TShardKey ShardKey;
        TString CreatedBy;
    };

    struct TEvShardCreated: public NActors::TEventLocal<TEvShardCreated, TRouterEvents::EvShardCreated> {
        TEvShardCreated(TShardId shardId, TShardKey key, TString host)
            : ShardId{std::move(shardId)}
            , ShardKey{std::move(key)}
            , Host{std::move(host)}
        {
        }

        TShardId ShardId;
        TShardKey ShardKey;
        TString Host;
    };

    NActors::IActor* CreateShardCreatorActor(IProcessingClusterClientPtr client, const IClusterMap& cluster);
} // namespace NSolomon::NFetcher
