#pragma once

#include <solomon/services/fetcher/lib/events.h>
#include <solomon/services/fetcher/lib/id.h>
#include <solomon/services/fetcher/lib/source_id/factory.h>
#include <solomon/services/fetcher/lib/url/url_state.h>

#include <solomon/libs/cpp/solomon_env/dc.h>
#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/shard_key/shard_key.h>
#include <solomon/protos/common/url_info.pb.h>

#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/ipv6_address/ipv6_address.h>

namespace NSolomon::NFetcher {
    struct TShardEvents: private TEventSlot<EEventSpace::Fetcher, FS_SHARD> {
        enum {
            Start = SpaceBegin,
            EvTargetsStatusRequest,
            EvTargetsStatusResponse,
            EvShardsStatsRequest,
            EvShardsStatsResponse,
            EvShardsHealthRequest,
            EvShardsHealthResponse,

            EvStartTracing,
            EvStopTracing,
            EvTracingOk,
            EvNotFound,

            EvShardResolved,
            EvResolveCluster,
            EvClusterResolved,
            EvClusterUnsubscribe,

            End,
        };
        static_assert(End < SpaceEnd, "too many event types");
    };

    struct TShardHealth {
        ui32 NumId{0};
        ui64 UrlsOk{0};
        ui64 UrlsFail{0};
    };

    struct TEvShardsHealthRequest: NActors::TEventLocal<TEvShardsHealthRequest, TShardEvents::EvShardsHealthRequest> { };

    struct TEvShardsHealthResponse: NActors::TEventLocal<TEvShardsHealthResponse, TShardEvents::EvShardsHealthResponse> {
        TEvShardsHealthResponse(TVector<TShardHealth>&& shards)
            : Shards{std::move(shards)}
        {
        }

        TVector<TShardHealth> Shards;
    };

    struct TEvShardStatsRequest: NActors::TEventLocal<TEvShardStatsRequest, TShardEvents::EvShardsStatsRequest> { };

    struct TShardStats {
        ui32 NumId{0};
        ui64 UrlCount{0};
    };

    struct TEvShardStatsResponse: NActors::TEventLocal<TEvShardStatsResponse, TShardEvents::EvShardsStatsResponse> {
        TEvShardStatsResponse(TVector<TShardStats>&& stats)
            : ShardStats{std::move(stats)}
        {
        }

        TVector<TShardStats> ShardStats;
    };

    struct TEvTargetsStatusRequest: NActors::TEventLocal<TEvTargetsStatusRequest, TShardEvents::EvTargetsStatusRequest> {
        ui32 NumId{0};
        TString ServiceProviderId;
        TString HostGlob;
        yandex::solomon::common::UrlStatusType Status{}; // UNKNOWN
        ui32 Offset{0};
        ui32 Limit{0};
        bool NotOk{false};
        EDc Dc;
    };

    struct TEvTargetsStatusResponse: NActors::TEventLocal<TEvTargetsStatusResponse, TShardEvents::EvTargetsStatusResponse> {
        TEvTargetsStatusResponse(TVector<TUrlAndShardsStatus> statuses, ui64 total)
            : Statuses{std::move(statuses)}
            , Total{total}
        {
        }

        TVector<TUrlAndShardsStatus> Statuses;
        ui64 Total{0};
    };

    struct TEvStartTracing: NActors::TEventLocal<TEvStartTracing, TShardEvents::EvStartTracing> {
        TEvStartTracing(TString shardId)
            : ShardId{std::move(shardId)}
        {
        }

        const TString ShardId;
    };

    struct TEvStopTracing: NActors::TEventLocal<TEvStopTracing, TShardEvents::EvStopTracing> {
        TEvStopTracing(TString shardId)
            : ShardId{std::move(shardId)}
        {
        }

        const TString ShardId;
    };

    struct TEvTracingOk: NActors::TEventLocal<TEvTracingOk, TShardEvents::EvTracingOk> { };
    struct TEvNotFound: NActors::TEventLocal<TEvNotFound, TShardEvents::EvNotFound> { };

} // namespace NSolomon::NFetcher
