#pragma once

#include "counters.h"

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/services/fetcher/lib/fetcher_shard.h>

#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/actors/core/events.h>

namespace NSolomon::NFetcher {
    // for tests, don't use anything from this file directly
    struct TLocalEvents: private TPrivateEvents {
        enum {
            EvShardChanged = SpaceBegin,
            EvRecycleCounters,
            End,
        };
        static_assert(End < SpaceEnd, "too many event types");
    };

    struct TEvShardChanged: NActors::TEventLocal<TEvShardChanged, TLocalEvents::EvShardChanged> {
        TEvShardChanged(TFetcherShard shard)
            : Shard{std::move(shard)}
        {
        }

        TFetcherShard Shard;
    };
} // namespace NSolomon::NFetcher
