#pragma once

#include "counters.h"

#include <solomon/services/fetcher/config/fetcher_config.pb.h>
#include <solomon/services/fetcher/lib/fetcher_shard.h>
#include <solomon/services/fetcher/lib/host_list_cache/host_list_cache.h>
#include <solomon/services/fetcher/lib/yasm/itype_white_list.h>

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/dns/dns.h>
#include <solomon/libs/cpp/limiter/limiter.h>

#include <library/cpp/actors/core/actorid.h>
#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon::NFetcher {
    class IFetcherUrlFactory;

    struct TShardManagerConfig {
        IHostListCachePtr HostListCache;
        NActors::TActorId DataSinkId;
        NActors::TActorId AuthGatekeeperId;
        NActors::TActorId ClusterManagerId;
        ui64 MaxInflight{0};
        IYasmItypeWhiteListPtr YasmWhiteList;
        TString YasmPrefix;
        TString IamServiceId;
    };

    NActors::IActor* CreateShardManagerActor(const TShardManagerConfig& config);

    /// for tests
    struct TShardActorConfig {
        TFetcherShard ShardConf;

        // nullptr means that we shouldn't use cache
        IHostListCachePtr HostListCache{nullptr};
        IShardMetricsPtr Metrics;
        std::shared_ptr<IFetcherUrlFactory> UrlFactory;
        ILimiterPtr Limiter;
        NActors::TActorId DataSinkId;
        NActors::TActorId ContinuousResolverId;
        NActors::TActorId StatCollectorId;
        NActors::TActorId AuthGatekeeperId;
        NActors::TActorId ClusterManagerId;
    };

    NActors::IActor* CreateFetcherShardActor(TShardActorConfig config);
} // namespace NSolomon::NFetcher
