#pragma once

#include "events.h"

#include <solomon/services/fetcher/lib/app_data.h>
#include <solomon/services/fetcher/lib/host_groups/host_and_labels.h>
#include <solomon/services/fetcher/lib/host_groups/host_resolver.h>
#include <solomon/services/fetcher/lib/host_list_cache/host_list_cache.h>
#include <solomon/services/fetcher/lib/config_updater/config_updater.h>

#include <solomon/libs/cpp/actors/fwd.h>

#include <library/cpp/actors/core/actorid.h>
#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/monlib/metrics/fwd.h>
#include <library/cpp/monlib/metrics/labels.h>

#include <util/generic/hash.h>
#include <util/generic/ptr.h>

#include <utility>

namespace NSolomon::NFetcher {
    using TClusterResolveResult = TErrorOr<THashSet<THostAndLabels>, TResolveError>;
    using TResolveResults = THashMap<IHostGroupResolverPtr, TClusterResolveResult>;
    using TResolveResultsPtr = TAtomicSharedPtr<const TResolveResults>;

    struct TEvClusterResolved: NActors::TEventLocal<TEvClusterResolved, TShardEvents::EvClusterResolved> {
        TEvClusterResolved(TClusterId id, TResolveResultsPtr result)
            : Id{std::move(id)}
            , Result{std::move(result)}
        {
        }

        TClusterId Id;
        TResolveResultsPtr Result;
    };

    struct TEvResolveCluster: NActors::TEventLocal<TEvResolveCluster, TShardEvents::EvResolveCluster> {
        enum class ESubscriptionType {
            Once,
            Forced,
            Subscribe,
        };

        TEvResolveCluster(IFetcherClusterPtr cluster, ESubscriptionType subscription = ESubscriptionType::Subscribe)
            : Cluster{std::move(cluster)}
            , SubscriptionType{subscription}
        {
        }

        IFetcherClusterPtr Cluster;
        ESubscriptionType SubscriptionType;
    };

    struct TEvClusterUnsubscribe: NActors::TEventLocal<TEvClusterUnsubscribe, TShardEvents::EvClusterUnsubscribe> {
        TEvClusterUnsubscribe(TClusterId id)
            : Id{std::move(id)}
        {
        }

        TClusterId Id;
    };

    TVector<TErrorOr<IHostGroupResolverPtr, TGenericError>> CreateResolversForCluster(const NDb::NModel::TClusterConfig& cluster, TAppData& appData);

    NActors::IActor* CreateClusterManager(NMonitoring::IMetricRegistry&, IHostResolverFactoryPtr resolverFactory, IHostListCachePtr hostListCache = {});
    NActors::IActor* ResolveCluster(TVector<IHostGroupResolverPtr> resolvers, NActors::TActorId receiver, TDuration timeout = TDuration::Max());

    // Don't use it directly -- make request to cluster manager instead
    NActors::IActor* CreateClusterActor(
        NMonitoring::IMetricRegistry& registry,
        IFetcherClusterPtr cluster,
        IHostResolverFactoryPtr resolverFactory,
        NActors::TActorId receiver);
} // namespace NSolomon::NFetcher
