#pragma once

#include "events.h"

#include <solomon/services/fetcher/lib/racktables/dc_matcher.h>

#include <solomon/libs/cpp/actors/fwd.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NFetcher {
    struct IShardStatCollector {
        virtual ~IShardStatCollector() = default;

        virtual TShardHealth ShardHealth() const = 0;
        virtual TShardStats ShardStats() const = 0;
    };

    std::pair<IShardStatCollector*, NActors::TActorId> CreateShardStatCollector(const NActors::TActorContext& parentCtx, ui32 numId);

    // for private use
    struct TShardStatEvents: private TPrivateEvents {
        enum {
            Begin = SpaceBegin,
            EvReportShardStats,
            EvReportUrlStatus,
            EvReportShardStatus,
            EvRemoveStats,
            End,
        };
        static_assert(End < SpaceEnd, "too many event types");
    };

    struct TEvReportUrlStatus: public NActors::TEventLocal<TEvReportUrlStatus, TShardStatEvents::EvReportUrlStatus> {
        TEvReportUrlStatus(ui64 epoch, TUrlStatus status)
            : Epoch{epoch}
            , Status{std::move(status)}
        {
        }

        ui64 Epoch;
        TUrlStatus Status;
    };

    struct TEvReportShardStatus: public NActors::TEventLocal<TEvReportShardStatus, TShardStatEvents::EvReportShardStatus> {
        TEvReportShardStatus(TString url, TShardStatus status)
            : Url{std::move(url)}
            , Status{std::move(status)}
        {
        }

        TString Url;
        TShardStatus Status;
    };

    struct TEvRemoveStats: public NActors::TEventLocal<TEvRemoveStats, TShardStatEvents::EvRemoveStats> {
        TEvRemoveStats(TString url)
            : Url{std::move(url)}
        {
        }

        TString Url;
    };
} // namespace NSolomon::NFetcher
