#include <solomon/services/fetcher/lib/shard_manager/counters.h>

#include <library/cpp/monlib/consumers/collecting_consumer.h>
#include <library/cpp/testing/gtest/gtest.h>

#include <util/generic/hash_set.h>

using namespace testing;
using namespace NSolomon;
using namespace NSolomon::NFetcher;
using namespace NMonitoring;

MATCHER_P(HasLabel, label, "") {
    auto maybeLabel = arg.Labels.Get(label.Name());
    if (!maybeLabel) {
        return false;
    }

    return (*maybeLabel)->Value() == label.Value();
}

class TShardMetricsTest: public ::testing::Test {
public:
    void SetUp() override {
        Registry_.Reset(new TMetricRegistry);
        Factory_ = CreateShardMetricFactory(*Registry_, EMetricVerbosity::All);
    }

    void TearDown() override {
        Factory_.Reset();
        Registry_.Reset();
    }

protected:
    THashSet<TString> GetProjectLabels() {
        TCollectingConsumer consumer;
        Registry_->Accept(TInstant::Zero(), &consumer);
        THashSet<TString> projects;
        for (auto&& m: consumer.Metrics) {
            if (auto projLabel = m.Labels.Extract("projectId")) {
                projects.emplace(projLabel->Value());
            }
        }

        return projects;
    }

protected:
    THolder<IShardMetricFactory> Factory_;
    THolder<TMetricRegistry> Registry_;
};

TEST_F(TShardMetricsTest, FactoryProjectCounter) {
    auto shard1 = Factory_->MetricsFor("projId", "shard1");
    auto shard2 = Factory_->MetricsFor("projId", "shard2");
    ASSERT_THAT(GetProjectLabels(), Contains("projId"));
}

TEST_F(TShardMetricsTest, NoShardMetrics) {
    TearDown();
    Registry_.Reset(new TMetricRegistry);
    Factory_.Reset(CreateShardMetricFactory(*Registry_, EMetricVerbosity::OnlyTotal));

    auto shard2 = Factory_->MetricsFor("projId", "shard2");
    TCollectingConsumer consumer;
    Registry_->Accept(TInstant::Zero(), &consumer);
    ASSERT_THAT(consumer.Metrics, Not(Contains(HasLabel(TLabel{"shardId", "shard2"}))));
    ASSERT_THAT(consumer.Metrics, Contains(HasLabel(TLabel{"shardId", "total"})));
}
