#pragma once

#include <solomon/services/fetcher/lib/events.h>
#include <solomon/services/fetcher/lib/id.h>
#include <solomon/services/fetcher/lib/source_id/factory.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/protos/common/url_info.pb.h>

#include <library/cpp/actors/core/event_local.h>

#include <library/cpp/monlib/encode/format.h>
#include <library/cpp/monlib/metrics/labels.h>

namespace NSolomon::NFetcher {
    struct TSinkEvents: private TEventSlot<EEventSpace::Fetcher, FS_SINK> {
        enum {
            EvWrite = SpaceBegin,
            EvMetricDataWritten,
            EvDataReceived,
            End,
        };
        static_assert(End < SpaceEnd, "too many event types");
    };

    struct TShardData {
        size_t Size() const noexcept {
            return Data.size() + PrevData.size();
        }

        TString ProjectId;

        // usually either shard id or service/cluster names are initialized
        TShardId ShardId;

        TString ServiceName;
        TString ClusterName;

        TString Host;
        TString Url;
        TDuration Interval;

        NMonitoring::EFormat Format;
        NMonitoring::TLabels Labels;

        TString Data;
        TInstant Instant;

        TString PrevData;
        TInstant PrevInstant;

        TSourceId SourceId;
        TString ProviderAccountId;
    };

    struct TEvSinkWrite: NActors::TEventLocal<TEvSinkWrite, TSinkEvents::EvWrite> {
        TEvSinkWrite(TShardData&& data)
            : ShardData{std::move(data)}
        {
        }

        TEvSinkWrite() = default;
        TEvSinkWrite(TEvSinkWrite&&) = default;
        TEvSinkWrite(const TEvSinkWrite&) = default;
        TEvSinkWrite& operator=(TEvSinkWrite&&) = default;
        TEvSinkWrite& operator=(const TEvSinkWrite&) = default;

        // common for both samples
        TShardData ShardData;
    };

    struct TEvDataReceived: NActors::TEventLocal<TEvDataReceived, TSinkEvents::EvDataReceived> {
        enum class EResult {
            Written = 0,
            Postponed = 1,
            Dropped = 2,
        };

        TEvDataReceived(EResult result)
            : Result{result}
        {
        }

        EResult Result;
    };

    struct TEvMetricDataWritten: NActors::TEventLocal<TEvMetricDataWritten, TSinkEvents::EvMetricDataWritten> {
        TEvMetricDataWritten(
                TString shardId,
                yandex::solomon::common::UrlStatusType status,
                ui64 metricsParsed,
                TString error)
            : ShardId{std::move(shardId)}
            , Status{status}
            , MetricsParsed{metricsParsed}
            , Error{std::move(error)} {
        }

        TString ShardId;
        yandex::solomon::common::UrlStatusType Status;
        ui64 MetricsParsed{};
        TString Error;
    };


    NActors::IActor* CreateDebugDataSink();
    NActors::IActor* CreateNullDataSink();
} // namespace NSolomon::NFetcher
