#pragma once

#include <library/cpp/ipv6_address/ipv6_address.h>

namespace NSolomon::NFetcher {
    using TSourceId = ui64;

    class ISourceIdFactory {
    public:
        virtual ~ISourceIdFactory() = default;
        virtual TSourceId Create(TIpv6Address addr, ui16 port, TStringBuf url) const = 0;
    };

    using ISourceIdFactoryPtr = THolder<ISourceIdFactory>;

    ISourceIdFactoryPtr CreateSourceIdFactory(const class TFetcherShard& shard);
    ISourceIdFactoryPtr DefaultSourceIdFactory();
} // namespace NSolomon::NFetcher
