#include <solomon/services/fetcher/lib/source_id/factory.h>

#include <solomon/services/fetcher/testlib/fetcher_shard.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/digest/crc32c/crc32c.h>

#include <util/string/hex.h>

using namespace NSolomon::NFetcher;
using namespace NSolomon::NTesting;

std::tuple<ui16, ui16, ui32> Unpack(TSourceId sourceId) {
    ui16 urlHash = sourceId >> 48;
    ui16 port = (sourceId >> 32) & 0xffff;
    ui32 addr = sourceId & ui64{~ui32{0}};
    return {urlHash, port, addr};
}

TEST(TSourceIdTest, Simple) {
    TFetcherShard shard{TFetcherShardFactory{}.MakeShard().Release()};
    auto factory = CreateSourceIdFactory(shard);

    TStringBuf addrString{"2a02:6b8:b000:a308:215:b2ff:fea9:67d2"};
    bool ok;
    TIpv6Address addr = TIpv6Address::FromString(addrString, ok);

    TStringBuf url = "solomon-dev-myt-00.search.yandex.net:1337/path";
    auto sourceId = factory->Create(addr, 1337, url);
    auto [hash, port, addrHost] = Unpack(sourceId);
    ui32 expectedHash = Crc32c(url.data(), url.size()) & 0xffff;
    ASSERT_EQ(port, 1337);
    ASSERT_EQ(hash, expectedHash);
    ASSERT_EQ(addrHost, GetLow(ui128(addr) & ~ui32{0}));
}
