#pragma once

#include <solomon/services/fetcher/lib/fetcher_shard.h>
#include <solomon/services/fetcher/lib/shard_manager/counters.h>
#include <solomon/services/fetcher/lib/yasm/itype_white_list.h>

#include <solomon/libs/cpp/auth/tvm/tvm.h>
#include <solomon/libs/cpp/cloud/iam/iam.h>

namespace NSolomon::NFetcher {

class TFetcherUrlBase;

class IFetcherUrlFactory {
public:
    virtual ~IFetcherUrlFactory() = default;

    virtual std::unique_ptr<NActors::IActor> CreateUrlParser(
            const TFetcherShard& shard,
            TString host,
            IShardMetricsPtr metrics) = 0;

    virtual std::unique_ptr<TFetcherUrlBase> CreateUrl(TFetcherShard shard, THostAndLabels hostAndLabels) = 0;
};

std::shared_ptr<IFetcherUrlFactory> CreateFetcherUrlFactory(
        NAuth::NTvm::ITicketProviderPtr ticketProvider,
        NCloud::ITokenProviderPtr iamTokenProvider,
        TClusterInfo clusterInfo,
        IYasmItypeWhiteListPtr yasmWhiteList = nullptr,
        TStringBuf yasmPrefix = DEFAULT_YASM_PREFIX);

} // namespace NSolomon::NFetcher
