#include "headers.h"

#include <library/cpp/digest/md5/md5.h>
#include <library/cpp/svnversion/svnversion.h>
#include <library/cpp/monlib/encode/format.h>

#include <util/string/builder.h>
#include <util/system/hostname.h>

namespace NSolomon::NFetcher {
    const TString NAME_SHARD_LIMIT = "X-Solomon-Shard-Limit";
    const TString NAME_FETCHER_ID = "X-Solomon-FetcherId";
    const TString NAME_CLUSTER_ID = "X-Solomon-ClusterId";
    const TString NAME_SEQUENCE_NUMBER = "X-Solomon-SequenceNumber";
    const TString NAME_NEXT_SEQUENCE_NUMBER = "x-solomon-nextsequencenumber";
    const TString NAME_HAS_MORE = "X-Solomon-HasMore";
    const TString NAME_ACCEPT = "Accept";
    const TString NAME_ACCEPT_ENCODING = "Accept-Encoding";
    const TString NAME_AUTHORIZATION = "Authorization";
    const TString NAME_TVM_TICKET = "X-Ya-Service-Ticket";
    const TString NAME_HOST = "Host";
    const TString NAME_GRID_SECONDS = "X-Solomon-GridSec";

    const TString VALUE_USER_AGENT = TStringBuilder() << "Solomon-Fetcher/" << GetProgramSvnRevision();
    const TString VALUE_FETCHER_ID = MD5::Calc(HostName());

    const TString VALUE_ACCEPT = TStringBuilder()
        << NMonitoring::NFormatContenType::SPACK << ", "
        << NMonitoring::NFormatContenType::JSON << ", "
        << "*/*";

    const TString VALUE_ACCEPT_ENCODING = "zstd,lz4,identity";
    const TString VALUE_IAM_TOKEN_KEY = "Bearer";
} // namespace NSolomon::NFetcher
