#pragma once

#include <util/datetime/base.h>
#include <util/random/random.h>

namespace NSolomon::NFetcher {
    inline TInstant RoundToPrev(TInstant instant, TDuration interval) {
        const auto instantMillis = instant.MilliSeconds();
        const auto intervalMillis = interval.MilliSeconds();

        return TInstant::MilliSeconds(instantMillis - (instantMillis % intervalMillis));
    }

    inline TDuration DelayToNextRound(TInstant instant, TDuration interval) {
        const auto instantMillis = instant.MilliSeconds();
        const auto intervalMillis = interval.MilliSeconds();

        return TDuration::MilliSeconds(intervalMillis - (instantMillis % intervalMillis));
    }

    constexpr TDuration MIN_INTERVAL = TDuration::Seconds(5);
    constexpr TDuration MAX_INTERVAL = TDuration::Hours(1);
} // namespace NSolomon::NFetcher
