#pragma once

#include <solomon/services/fetcher/lib/events.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/http/client/http.h>
#include <solomon/libs/cpp/shard_key/shard_key.h>
#include <solomon/protos/common/url_info.pb.h>

#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/monlib/encode/format.h>

namespace NSolomon::NFetcher {

struct TParsedData {
    NMonitoring::EFormat Format{NMonitoring::EFormat::UNKNOWN};
    TShardKey Key;
    TString Data;
};

class TUrlParserEvents: public TEventSlot<EEventSpace::Fetcher, FS_URL_PARSER> {
    enum {
        Parse = SpaceBegin,
        ParseResult,
        ParseError,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TParse: public NActors::TEventLocal<TParse, Parse> {
        IResponsePtr Response;

        explicit TParse(IResponsePtr response) noexcept
            : Response{std::move(response)}
        {
        }
    };

    struct TParseResult: public NActors::TEventLocal<TParseResult, ParseResult> {
        NMonitoring::EFormat Format;
        NMonitoring::ECompression Compression;
        bool HasMore;
        std::variant<ui64, TString> NextToken;
        std::vector<TParsedData> Data;

        TParseResult(
                NMonitoring::EFormat format,
                NMonitoring::ECompression compression,
                bool hasMore,
                std::variant<ui64, TString> nextToken) noexcept
            : Format{format}
            , Compression{compression}
            , HasMore{hasMore}
            , NextToken{std::move(nextToken)}
        {
        }
    };

    struct TParseError: public NActors::TEventLocal<TParseError, ParseError> {
        yandex::solomon::common::UrlStatusType Status;
        TString Message;

        TParseError(yandex::solomon::common::UrlStatusType status, TString message) noexcept
            : Status{status}
            , Message{std::move(message)}
        {
        }
    };
};

} // namespace NSolomon::NFetcher
