#include "ts_args.h"

#include <util/string/builder.h>

namespace NSolomon::NFetcher {
    TString FormatDuration(TDuration d) {
        TStringBuilder sb;

        if (auto days = d.Days(); days != 0) {
            sb << days << 'd';
            d -= TDuration::Days(days);
        }

        if (auto hours = d.Hours(); hours != 0) {
            sb << hours << 'h';
            d -= TDuration::Hours(hours);
        }

        if (auto minutes = d.Minutes(); minutes != 0) {
            sb << minutes << 'm';
            d -= TDuration::Minutes(minutes);
        }

        if (auto seconds = d.Seconds(); seconds != 0) {
            sb << seconds << 's';
        }

        if (sb.size() == 0) {
            static const TString ZERO{"0"};
            return ZERO;
        }

        return sb;
    }

    TString MakeTsParams(TDuration interval, TInstant prev, TInstant now) {
        TStringBuilder sb;

        const auto period = prev == TInstant::Zero()
            ? interval
            : now - prev;

        sb << "now=" << now.ToStringUpToSeconds() << "&period=" << FormatDuration(period);

        return sb;
    }
} // namespace NSolomon::NFetcher
