#pragma once

#include "fetcher_url_factory.h"

#include <solomon/services/fetcher/lib/host_groups/host_and_labels.h>
#include <solomon/services/fetcher/lib/fetcher_shard.h>
#include <solomon/services/fetcher/lib/shard_manager/counters.h>

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/http/client/http.h>
#include <solomon/libs/cpp/limiter/limiter.h>
#include <solomon/protos/common/url_info.pb.h>

#include <library/cpp/monlib/metrics/fwd.h>

#include <util/datetime/base.h>

namespace NSolomon::NFetcher {
    // for tests, don't use otherwise
    constexpr ui64 DEFUNCT_WAKEUP_TAG = 1337;

    TString MakeUrl(const TFetcherShard& shard, const THostAndLabels& hostAndLabels, TMaybeIp maybeIp = Nothing());

    NActors::IActor* CreateUrlActor(
            THostAndLabels hostAndLabels, TFetcherShard shardConf, IFetcherUrlFactory& urlFactory,
            NActors::TActorId parserId,
            NActors::TActorId dnsResolverId, NActors::TActorId dataSinkId, NActors::TActorId statCollectorId,
            NActors::TActorId authGatekeeper,
            IShardMetricsPtr metrics, ILimiterPtr limiter, IHttpClientPtr httpClient);
} // namespace NSolomon::NFetcher
