#pragma once

#include <solomon/services/fetcher/lib/source_id/factory.h>
#include <solomon/libs/cpp/shard_key/shard_key.h>

#include <solomon/libs/cpp/solomon_env/dc.h>
#include <solomon/protos/common/url_info.pb.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>

#include <util/generic/vector.h>

namespace NSolomon::NFetcher {

enum class EUrlActorState {
    Defunct,
    Working,
    Idle
};

struct TShardStatus {
    TString ShardId{};
    yandex::solomon::common::UrlStatusType Status{}; // UNKNOWNN
    TString Error{};
    ui64 MetricsParsed{};
    TInstant LastOverflow{};
};

struct TUrlStatus {
    TString Host;
    EDc Dc{EDc::UNKNOWN};
    TInstant FetchTime;
    TDuration FetchDuration;
    ui64 ResponseBytes{};
    yandex::solomon::common::UrlStatusType UrlStatus{}; // UNKNOWNN
    TString UrlError;
    TString Url;
    yandex::solomon::common::UrlContentType ContentType{}; // UNKNOWN
};

struct TUrlAndShardsStatus {
    ui64 Epoch{};
    TUrlStatus Url;
    absl::flat_hash_map<TString, TShardStatus> ShardIdToShardStatus;
};

struct TUrlState {
    EUrlActorState State;
    TString DisplayUrl;
    TString EffectiveUrl;

    TUrlStatus Status;
    TIpv6Address IpAddress;
    TSourceId SourceId;
    THashMap<TShardKey, TString> LastResponse;
};

} // namespace NSolomon::NFetcher
