#include <solomon/services/fetcher/lib/fetcher_shard.h>
#include <solomon/services/fetcher/lib/host_groups/host_and_labels.h>
#include <solomon/services/fetcher/lib/url/fetcher_url.h>
#include <solomon/services/fetcher/lib/url/fetcher_url_factory.h>
#include <solomon/services/fetcher/testlib/tvm.h>

#include <library/cpp/http/misc/http_headers.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NMonitoring;
using namespace NSolomon;
using namespace NSolomon::NTesting;
using namespace NSolomon::NFetcher;
using namespace NHttpHeaders;
using namespace testing;
using namespace NSolomon::NAuth::NTvm;

namespace {
    ITicketProviderPtr MOCK_TICKET_PROVIDER = MakeIntrusive<TMockTicketProvider>();
    TIpv6Address AGENT_IP = [] {
        bool ok;
        const auto addr = TIpv6Address::FromString("::3", ok);
        Y_VERIFY(ok);
        return addr;
    }();

    const TString DEFAULT_URL = TStringBuilder() << "http://[" << AGENT_IP.ToString(false) << "]:" << 11003 << "/json";
}

class TYasmUrlTest: public ::testing::Test {
public:
    TYasmUrlTest()
        : UrlFactory_{CreateFetcherUrlFactory(MOCK_TICKET_PROVIDER, {}, {})}
        , Shard_{CreateYasmAgentShard({"yasm_monitored"})}
    {
    }

    void SetUp() override {
        Url_ = UrlFactory_->CreateUrl(Shard_, THostAndLabels{"my.hostname", 11003, AGENT_IP});
    }

protected:
    std::shared_ptr<IFetcherUrlFactory> UrlFactory_;
    TFetcherShard Shard_;
    std::unique_ptr<TFetcherUrlBase> Url_;
};

TEST_F(TYasmUrlTest, HostLabel) {
    ASSERT_THAT(Url_->Fqdn(), StrEq("my.hostname"));
    ASSERT_THAT(Url_->HostLabel(), StrEq("my.hostname"));
}

TEST_F(TYasmUrlTest, PrepareRequest) {
    auto req = Url_->PrepareRequest();
    ASSERT_THAT(req.Success(), true);
    auto& headers = req.Value().Headers;

    ASSERT_THAT(headers.at(ACCEPT), StrEq("application/x-protobuf"));
    ASSERT_THAT(headers.at(CONTENT_TYPE), StrEq("application/json"));

    ASSERT_THAT(req.Value().Url, StrEq(DEFAULT_URL));
    ASSERT_THAT(req.Value().Method, Eq(TFetchRequest::POST));
    ASSERT_THAT(req.Value().Body, Not(IsEmpty()));
}
