#pragma once

#include <solomon/libs/cpp/solomon_env/dc.h_serialized.h>

#include <library/cpp/ipv6_address/ipv6_address.h>

#include <array>

constexpr auto DC_COUNT = GetEnumItemsCount<NSolomon::EDc>();

const std::array<TIpv6Address, DC_COUNT> DC_ADDRS = [] {
    std::array<TIpv6Address, DC_COUNT> result;
    bool ok;

    for (auto i = 0u; i < DC_COUNT; ++i) {
        result[i] = TIpv6Address::FromString(TStringBuilder() << "::" << (4 + i), ok);
        Y_VERIFY(ok);
    }

    return result;
}();

const auto DEFAULT_IP = DC_ADDRS[size_t(NSolomon::EDc::VEG)];
