#include <solomon/services/fetcher/lib/yasm/encoder.h>
#include <solomon/services/fetcher/lib/yasm/message_string_pool.h>
#include <solomon/services/fetcher/lib/yasm/yasm_decoder.h>

#include <solomon/libs/cpp/yasm/shard_config/shard_config.h>

#include <infra/yasm/interfaces/internal/agent.pb.h>

#include <library/cpp/monlib/encode/spack/spack_v1.h>
#include <library/cpp/monlib/encode/text/text.h>
#include <library/cpp/resource/resource.h>

#include <util/stream/mem.h>
#include <util/stream/file.h>

using namespace NSolomon::NFetcher::NYasm;
using namespace NSolomon::NYasm;
using namespace NYasm::NInterfaces::NInternal;

int main(int argc, const char* argv[]) {
    TString host = (argc > 1) ? argv[1]: "";
    TString input = (argc > 2) ? TFileInput{argv[2]}.ReadAll() : Cin.ReadAll();

    TAgentResponse r;
    Y_ENSURE(r.ParseFromString(input));
    auto shardConf = NResource::Find("yasm_shards.conf");

    TVector<TShardData> data = DecodeYasmAgentResponse(
        *r.MutablePerInstanceRecords(),
        *r.MutableAggregatedRecords(),
        *CreateShardConfig(shardConf),
        CreateMultiShardEncoder(NMonitoring::ECompression::IDENTITY),
        host
    );

    std::sort(data.begin(), data.end(), [](const TShardData& lhs, const TShardData& rhs) {
        return lhs.Key.GetShardId() < rhs.Key.GetShardId();
    });

    for (auto&& d: data) {
        Cout << "------------------------\n";
        Cout << "yasm_" << d.Key.GetItype() << ' ' << d.Key.GetShardId() << " yasm " << d.Key.GetCluster() << '\n';

        TMemoryInput in{d.Data};
        auto encoder = NMonitoring::EncoderText(&Cout);
        DecodeSpackV1(&in, encoder.Get());
    }

    return 0;
}
