#include "common.h"

#include <library/cpp/resource/resource.h>
#include <library/cpp/yaml/as/tstring.h>

#include <util/string/split.h>

#include <unordered_map>

namespace NSolomon::NFetcher::NYasm {
namespace {

constexpr TStringBuf TYPE_LABEL = TStringBuf("itype");

class TCommonRulesMatcher {
public:
    TCommonRulesMatcher(TStringBuf rulesPath) {
        TString rulesConfig = NResource::Find(rulesPath);
        YAML::Node yamlRules = YAML::Load(static_cast<std::string>(TStringBuf(rulesConfig.Data(), rulesConfig.Size())));

        auto commonRules = yamlRules["common_rules"];

        for (const auto& rule: commonRules) {
            auto rulesStr = rule["request_key"].as<TString>();
            TString itype;
            TVector<NMonitoring::TLabel> rules;
            for (auto it: StringSplitter(rulesStr.begin(), rulesStr.end()).Split(';')) {
                NMonitoring::TLabel label = NMonitoring::TLabel::FromString(it.Token());
                if (label.Name() == TYPE_LABEL) {
                    itype = label.Value();
                } else {
                    rules.emplace_back(std::move(label));
                }
            }

            Y_ENSURE(itype, "itype not found in common rule:" << rulesStr);

            auto [it, _] = RulesTable_.emplace(std::make_pair(itype, TYasmCommonRule{}));
            if (!rules.empty()) {
                it->second.emplace_back(std::move(rules));
            }
        }
    }

    const TRuleMap& Table() const {
        return RulesTable_;
    }

private:
    TRuleMap RulesTable_;
};

} // namespace

constexpr TStringBuf RULES_PATH = TStringBuf("rules.conf");

const TRuleMap& GetCommonRulesTable(TStringBuf path) {
    // TODO: load path to file from config
    static TCommonRulesMatcher matcher(path);
    return matcher.Table();
}

const TRuleMap& GetCommonRulesTable() {
    return GetCommonRulesTable(RULES_PATH);
}

} // namespace NSolomon::NFetcher::NYasm
